#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Experimento TruchetMod01.fsh   by   rubenbaca 
//https://www.shadertoy.com/view/lXjcWz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float hash21(vec2 p){
p=fract(p*(675.28,973.05));
p+=dot(p,p+334.78);
return fract(p.x*p.y);}


vec2 mobius(vec2 p, float a, float b, float c, float d) {
    return (p * vec2(a, b) + vec2(c, d)) / (p.x * p.x + p.y * p.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord / iResolution.xy;
    uv -= 0.5;
    uv.x *= iResolution.x / iResolution.y;
    uv  *= 10.0;
    //uv += iTime * 0.6;

    // Apply a Möbius transformation
   
uv = mobius(uv, iTime*.4, iTime*.4, iTime*.4, iTime*.4);
    //uv = mobius(uv, 2.0, 2.0, 4.0, 4.0);

    vec2 gv = fract(uv) - 0.5; // Local coordinates

    
vec2 id=floor(uv);
    float n=hash21(id);
    
    
    float d=smoothstep(.1,.11,length(uv));

 
   
    vec3 col =vec3(0); //Color predeterminado
    // Textura para el interior
  

    
    //col.rg=gv;
    if(n>.5) gv.x*=-1.; //Aleatorio
    float ancho=.1;
    d=abs(abs(gv.y+gv.x)-.5); //Para patrón rectangular
   
    vec2 Cuv= gv-.5*sign(gv.y+gv.x+.001);
    d=length(Cuv)-.5;
    float mask=smoothstep(.01,-.012,abs(d)-ancho);
    
    col+=mask;
   
   
    //if(gv.x>.48||gv.y>.48) col=vec3(1,0,0);
      vec3 texColor = texture2D(texture0, uv).rgb;

    // Textura combinada con el cálculo original del color.
    col = mix(col, texColor, mask);
   
    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

